<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BranchLanguage extends Model 
{

    protected $table = 'lim_branch_languages';
    public $timestamps = true;
    protected $fillable = array('lim_language_id', 'lim_branch_id', 'name', 'content');
    protected $visible = array('lim_language_id', 'lim_branch_id', 'name', 'content');

    public function language()
    {
        return $this->belongsTo('App\Models\Language', 'lim_language_id');
    }

    public function branch()
    {
        return $this->belongsTo('App\Models\Branch', 'lim_branch_id');
    }

}